/*
 * Decompiled with CFR 0.152.
 */
package betterquesting.api2.client.gui.resources.textures;

import betterquesting.api2.client.gui.misc.GuiRectangle;
import betterquesting.api2.client.gui.misc.IGuiRect;
import betterquesting.api2.client.gui.resources.colors.GuiColorStatic;
import betterquesting.api2.client.gui.resources.colors.IGuiColor;
import betterquesting.api2.client.gui.resources.textures.IGuiTexture;
import betterquesting.api2.client.gui.themes.presets.PresetTexture;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.FluidStack;

public class FluidTexture
implements IGuiTexture {
    private static final IGuiColor defColor = new GuiColorStatic(255, 255, 255, 255);
    private final FluidStack fluid;
    private final boolean showCount;
    private final boolean keepAspect;
    private final IGuiRect bounds = new GuiRectangle(0, 0, 16, 16);

    public FluidTexture(FluidStack fluid) {
        this(fluid, false, true);
    }

    public FluidTexture(FluidStack fluid, boolean showCount, boolean keepAspect) {
        this.fluid = fluid;
        this.showCount = showCount;
        this.keepAspect = keepAspect;
    }

    @Override
    public void drawTexture(int x, int y, int width, int height, float zDepth, float partialTick) {
        this.drawTexture(x, y, width, height, zDepth, partialTick, defColor);
    }

    @Override
    public void drawTexture(int x, int y, int width, int height, float zDepth, float partialTick, IGuiColor color) {
        if (width <= 0 || height <= 0) {
            return;
        }
        float sx = (float)width / 16.0f;
        float sy = (float)height / 16.0f;
        double dx = 0.0;
        double dy = 0.0;
        if (this.keepAspect) {
            float sa = Math.min(sx, sy);
            dx = Math.floor((sx - sa) * 8.0f);
            dy = Math.floor((sy - sa) * 8.0f);
            sx = sa;
            sy = sa;
        }
        GlStateManager.func_179094_E();
        GlStateManager.func_179137_b((double)((double)x + dx), (double)((double)y + dy), (double)0.0);
        GlStateManager.func_179152_a((float)sx, (float)sy, (float)1.0f);
        GlStateManager.func_179147_l();
        GlStateManager.func_179120_a((int)770, (int)771, (int)1, (int)0);
        int fCol = this.fluid.getFluid().getColor(this.fluid);
        float a = (float)(fCol >> 24 & 0xFF) / 255.0f;
        float r = (float)(fCol >> 16 & 0xFF) / 255.0f;
        float g = (float)(fCol >> 8 & 0xFF) / 255.0f;
        float b = (float)(fCol & 0xFF) / 255.0f;
        GlStateManager.func_179131_c((float)(r += color.getRed() / 2.0f), (float)(g += color.getGreen() / 2.0f), (float)(b += color.getBlue() / 2.0f), (float)(a += color.getAlpha() / 2.0f));
        Minecraft mc = Minecraft.func_71410_x();
        mc.field_71446_o.func_110577_a(TextureMap.field_110575_b);
        TextureAtlasSprite fluidTx = mc.func_147117_R().func_110572_b(this.fluid.getFluid().getStill().toString());
        this.drawTexturedModalRect(0.0, 0.0, 0.0, fluidTx, 16.0, 16.0);
        GlStateManager.func_179121_F();
    }

    @Override
    public ResourceLocation getTexture() {
        return PresetTexture.TX_NULL;
    }

    @Override
    public IGuiRect getBounds() {
        return this.bounds;
    }

    private void drawTexturedModalRect(double xCoord, double yCoord, double zDepth, TextureAtlasSprite textureSprite, double widthIn, double heightIn) {
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder bufferbuilder = tessellator.func_178180_c();
        bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        bufferbuilder.func_181662_b(xCoord, yCoord + heightIn, zDepth).func_187315_a((double)textureSprite.func_94209_e(), (double)textureSprite.func_94210_h()).func_181675_d();
        bufferbuilder.func_181662_b(xCoord + widthIn, yCoord + heightIn, zDepth).func_187315_a((double)textureSprite.func_94212_f(), (double)textureSprite.func_94210_h()).func_181675_d();
        bufferbuilder.func_181662_b(xCoord + widthIn, yCoord, zDepth).func_187315_a((double)textureSprite.func_94212_f(), (double)textureSprite.func_94206_g()).func_181675_d();
        bufferbuilder.func_181662_b(xCoord, yCoord, zDepth).func_187315_a((double)textureSprite.func_94209_e(), (double)textureSprite.func_94206_g()).func_181675_d();
        tessellator.func_78381_a();
    }
}

